/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.origin.OriginUpgrade;
import io.github.apace100.origins.power.MultiplePowerType;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Origin {
    public static final SerializableData DATA = new SerializableData().add("powers", SerializableDataType.IDENTIFIERS, Lists.newArrayList()).add("icon", SerializableDataType.ITEM_OR_ITEM_STACK, new ItemStack((IItemProvider)Items.field_190931_a)).add("unchoosable", SerializableDataType.BOOLEAN, false).add("order", SerializableDataType.INT, Integer.MAX_VALUE).add("impact", SerializableDataType.IMPACT, Impact.NONE).add("loading_priority", SerializableDataType.INT, 0).add("upgrades", SerializableDataType.UPGRADES, null).add("name", SerializableDataType.STRING, "").add("description", SerializableDataType.STRING, "");
    public static final Origin EMPTY = Origin.register(new Origin(new ResourceLocation("origins", "empty"), new ItemStack((IItemProvider)Items.field_190931_a), Impact.NONE, -1, Integer.MAX_VALUE).setUnchoosable().setSpecial());
    private ResourceLocation identifier;
    private List<PowerType<?>> powerTypes = new LinkedList();
    private final ItemStack displayItem;
    private final Impact impact;
    private boolean isChoosable;
    private final int order;
    private final int loadingPriority;
    private List<OriginUpgrade> upgrades = new LinkedList<OriginUpgrade>();
    private boolean isSpecial;
    private String nameTranslationKey;
    private String descriptionTranslationKey;

    public static void init() {
    }

    private static Origin register(Origin origin) {
        return OriginRegistry.register(origin);
    }

    public static HashMap<OriginLayer, Origin> get(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return Origin.get((PlayerEntity)entity);
        }
        return new HashMap<OriginLayer, Origin>();
    }

    public static HashMap<OriginLayer, Origin> get(PlayerEntity player) {
        return ModComponentsArchitectury.getOriginComponent((Entity)player).getOrigins();
    }

    public Origin(ResourceLocation id, ItemStack icon, Impact impact, int order, int loadingPriority) {
        this.identifier = id;
        this.displayItem = icon.func_77946_l();
        this.impact = impact;
        this.isChoosable = true;
        this.order = order;
        this.loadingPriority = loadingPriority;
    }

    public Origin addUpgrade(OriginUpgrade upgrade) {
        this.upgrades.add(upgrade);
        return this;
    }

    public boolean hasUpgrade() {
        return this.upgrades.size() > 0;
    }

    public Optional<OriginUpgrade> getUpgrade(Advancement advancement) {
        for (OriginUpgrade upgrade : this.upgrades) {
            if (!upgrade.getAdvancementCondition().equals((Object)advancement.func_192067_g())) continue;
            return Optional.of(upgrade);
        }
        return Optional.empty();
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public Origin add(PowerType<?> ... powerTypes) {
        this.powerTypes.addAll(Lists.newArrayList((Object[])powerTypes));
        return this;
    }

    protected Origin setUnchoosable() {
        this.isChoosable = false;
        return this;
    }

    public Origin setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public Origin setName(String name) {
        this.nameTranslationKey = name;
        return this;
    }

    public Origin setDescription(String description) {
        this.descriptionTranslationKey = description;
        return this;
    }

    public boolean hasPowerType(PowerType<?> powerType) {
        if (powerType.getIdentifier() == null) {
            return false;
        }
        return this.powerTypes.contains(powerType);
    }

    public int getLoadingPriority() {
        return this.loadingPriority;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public boolean isChoosable() {
        return this.isChoosable;
    }

    public Iterable<PowerType<?>> getPowerTypes() {
        return this.powerTypes;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public String getOrCreateNameTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "origin." + this.identifier.func_110624_b() + "." + this.identifier.func_110623_a() + ".name";
        }
        return this.nameTranslationKey;
    }

    public TranslationTextComponent getName() {
        return new TranslationTextComponent(this.getOrCreateNameTranslationKey());
    }

    public String getOrCreateDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null || this.descriptionTranslationKey.isEmpty()) {
            this.descriptionTranslationKey = "origin." + this.identifier.func_110624_b() + "." + this.identifier.func_110623_a() + ".description";
        }
        return this.descriptionTranslationKey;
    }

    public TranslationTextComponent getDescription() {
        return new TranslationTextComponent(this.getOrCreateDescriptionTranslationKey());
    }

    public int getOrder() {
        return this.order;
    }

    public void write(PacketBuffer buffer) {
        DATA.write(buffer, this.dataInstance());
    }

    public SerializableData.Instance dataInstance() {
        SerializableData.Instance data = DATA.new SerializableData.Instance();
        data.set("icon", this.displayItem);
        data.set("impact", (Object)this.impact);
        data.set("order", this.order);
        data.set("loading_priority", this.loadingPriority);
        data.set("unchoosable", !this.isChoosable);
        data.set("powers", this.powerTypes.stream().map(PowerType::getIdentifier).collect(Collectors.toList()));
        data.set("name", this.getOrCreateNameTranslationKey());
        data.set("description", this.getOrCreateDescriptionTranslationKey());
        data.set("upgrades", this.upgrades);
        return data;
    }

    public static Origin createFromData(ResourceLocation id, SerializableData.Instance data) {
        Origin origin = new Origin(id, (ItemStack)data.get("icon"), (Impact)((Object)data.get("impact")), data.getInt("order"), data.getInt("loading_priority"));
        if (data.getBoolean("unchoosable")) {
            origin.setUnchoosable();
        }
        ((List)data.get("powers")).forEach(powerId -> {
            try {
                PowerType powerType = PowerTypeRegistry.get(powerId);
                origin.add(powerType);
                if (powerType instanceof MultiplePowerType) {
                    ImmutableList<ResourceLocation> subPowers = ((MultiplePowerType)powerType).getSubPowers();
                    for (ResourceLocation subPowerId : subPowers) {
                        origin.add(PowerTypeRegistry.get(subPowerId));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.error("Origin \"" + id + "\" contained unregistered power: \"" + powerId + "\"");
            }
        });
        if (data.isPresent("upgrades")) {
            ((List)data.get("upgrades")).forEach(origin::addUpgrade);
        }
        origin.setName((String)data.get("name"));
        origin.setDescription((String)data.get("description"));
        return origin;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Origin read(PacketBuffer buffer) {
        ResourceLocation identifier = ResourceLocation.func_208304_a((String)buffer.func_150789_c(Short.MAX_VALUE));
        return Origin.createFromData(identifier, DATA.read(buffer));
    }

    public static Origin fromJson(ResourceLocation id, JsonObject json) {
        return Origin.createFromData(id, DATA.read(json));
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Origin(" + this.identifier.toString() + ")[");
        for (PowerType<?> pt : this.powerTypes) {
            str.append(PowerTypeRegistry.getId(pt)).append(",");
        }
        str = new StringBuilder(str.substring(0, str.length() - 1) + "]");
        return str.toString();
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Origin) {
            return ((Origin)obj).identifier.equals((Object)this.identifier);
        }
        return false;
    }
}

